/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.logging;

import filenet.vw.base.VWString;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.ntutil.EventLog;
import filenet.vw.sysutils.OperatingSystem;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class VWEventLogHandler
extends AppenderSkeleton {
    private EventLog m_log = null;
    private String m_moduleName = null;
    private VWString m_msgString = null;

    public static void installGlobalHandler(String moduleName) {
        Logger.installAppender((Appender)new VWEventLogHandler(moduleName));
    }

    public VWEventLogHandler(String moduleName) {
        this.setName(moduleName);
        this.m_moduleName = moduleName;
        this.m_msgString = new VWString("filenet.vw.base.logging.VWEventLogHandler", "Source: {0}\n\n{1}");
        try {
            String serviceName = System.getProperty("filenet.vw.base.logging.ServiceName", "VWServices");
            this.m_log = new EventLog(serviceName);
            String sLevel = System.getProperty("filenet.pe.eventlog.level");
            Level l = Level.INFO;
            if (sLevel != null) {
                l = Level.parse(sLevel);
            }
            this.setThreshold((Priority)l);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean requiresLayout() {
        return false;
    }

    public void append(LoggingEvent record) {
        if (!OperatingSystem.isWindows() || this.m_log == null) {
            return;
        }
        try {
            String msg = this.m_msgString.toString(this.m_moduleName, record.getRenderedMessage());
            int level = record.getLevel().toInt();
            if (level == org.apache.log4j.Level.INFO.toInt()) {
                this.m_log.LogEvent(0x60000001L, msg, 4);
            } else if (level == org.apache.log4j.Level.WARN.toInt()) {
                this.m_log.LogEvent(0x60000001L, msg, 2);
            } else if (level == org.apache.log4j.Level.FATAL.toInt()) {
                this.m_log.LogEvent(0x60000001L, msg, 1);
            }
        }
        catch (Exception ex) {
            LogLog.warn((String)"VWEventLogHandler.append", (Throwable)ex);
        }
        catch (Throwable t) {
            this.m_log = null;
        }
    }

    public void close() {
        this.flush();
    }

    public void flush() {
    }

    public void setLevel(Level level) {
    }
}

